import { patch } from './utils';

describe('models/ui|utils/patch', () => {
   interface Obj {
      a: number;
      b: number;
      c: { x: number };
      d?: { x: number };
   }

   let obj: Obj;

   beforeEach(() => {
      obj = {
         a: 1,
         b: 2,
         c: {
            x: 1,
         },
      };
   });

   it('should patch existed property', () => {
      patch(obj, 'a', 0, () => 3);

      expect(obj.a).toBe(3);
   });

   it('should create object property', () => {
      patch(obj, 'd', {}, v => {
         v.x = 4;

         return v;
      });

      expect(obj.d!.x).toBe(4);
   });

   it('should not create unchanged object property', () => {
      patch(obj, 'd', {}, v => v);

      expect('d' in obj).toBe(false);
   });
});
