import { isEqual } from '@yandex-infracloud-ui/libs';

import {
   EEventType,
   EEvictionState,
   EHfsmState,
   EPodCurrentState,
   ESchedulingState,
   TMaintenanceInfo,
   TPodStatus_TEviction,
   TPodStatus_TMaintenance,
   TPodStatus_TScheduling,
   ENodeMaintenanceState,
   TNodeStatus_THfsm,
   TNodeStatus_TMaintenance,
} from '../../../proto-typings';
import { YpLocation } from '../../api';

export type YpRouteProps = {
   cluster: string;
   entityId: string;
};

export type YpEntityRouteProps = Pick<YpRouteProps, 'cluster' | 'entityId'>;

export const isEvictionsEqual = (first: TPodStatus_TEviction | null, second: TPodStatus_TEviction | null) => {
   if (first && second) {
      return first.message === second.message && first.state === second.state && first.reason === second.reason;
   }

   return Boolean(first) === Boolean(second);
};

const isInfoEqual = (first?: TMaintenanceInfo, second?: TMaintenanceInfo) => {
   if (first && second) {
      return isEqual(first, second);
   }

   return Boolean(first) === Boolean(second);
};

export const isMaintenancesEqual = (first: TPodStatus_TMaintenance | null, second: TPodStatus_TMaintenance | null) => {
   if (first && second) {
      return first.message === second.message && first.state === second.state && isInfoEqual(first.info, second.info);
   }

   return Boolean(first) === Boolean(second);
};

export const isSchedulingsEqual = (first: TPodStatus_TScheduling | null, second: TPodStatus_TScheduling | null) => {
   if (first && second) {
      return first.message === second.message && first.node_id === second.node_id && first.state === second.state;
   }

   return Boolean(first) === Boolean(second);
};

export const isNodeHistoryItemsEqual = (
   first: TNodeStatus_THfsm | TNodeStatus_TMaintenance | null,
   second: TNodeStatus_THfsm | TNodeStatus_TMaintenance | null,
) => {
   if (first && second) {
      return (
         first.message === second.message && first.last_updated === second.last_updated && first.state === second.state
      );
   }

   return Boolean(first) === Boolean(second);
};

export interface PodHistoryEvent {
   time: {
      seconds: number;
      nanos: number;
   };

   event_type: EEventType;

   result: {
      status: {
         eviction: TPodStatus_TEviction | null;
         maintenance: TPodStatus_TMaintenance | null;
         scheduling: TPodStatus_TScheduling | null;
      };
   };

   user: string;
}

export type NodeHistoryEvent = {
   time: { nanos: number; seconds: number };
   event_type: EEventType;
   result: {
      status: {
         hfsm: TNodeStatus_THfsm | null;
         maintenance: TNodeStatus_TMaintenance | null;
      };
   };
   user: string;
};

export const ProductionClusters = [
   YpLocation.IVA,
   YpLocation.MAN,
   YpLocation.MYT,
   YpLocation.SAS,
   YpLocation.VLA,
   YpLocation.XDC,
];

export const TestClusters = [YpLocation.MAN_PRE, YpLocation.SAS_TEST];
export interface NodeFiltersParams {
   nodeId?: string;
   segments?: string[];
   state?: EHfsmState[];
   maintenance?: ENodeMaintenanceState[];
   query?: string;
}

export interface PodsFiltersParams {
   podId?: string;
   podSetId?: string;
   service?: string;
   podState?: EPodCurrentState[];
   evictionState?: EEvictionState[];
   schedulingState?: ESchedulingState[];
   query?: string;
}

export interface PodSetsFiltersParams {
   podSetId?: string;
   serviceId?: string;
   segments?: string[];
   deployEngine?: DeployEngine[];
   accountId?: string;
   query?: string;
}

export enum DeployEngine {
   YPLite = 'YP_LITE',
   DeployRSC = 'RSC',
   DeployMCRSC = 'MCRSC',
   QYP = 'QYP',
}
