import {
   faBoxOpen,
   faCompactDisc,
   faFile,
   faHeartRate,
   faLayerGroup,
   faRocket,
   faServer,
   IconDefinition,
} from '@fortawesome/pro-regular-svg-icons';

/**
 * класс объектов yp, которые имеет в ui одинаковый вид, даже если являются частью разных объектов
 *
 * например бокс и в стейдже, и в поде мы изображаем как синюю коробку
 */
export enum YpViewPart {
   stage = 'stage',
   deployUnit = 'deployUnit',
   box = 'box',
   workload = 'workload',
   layer = 'layer',
   staticResource = 'staticResource',
   volume = 'volume',
}

export type ViewData = {
   fontAwesomeIcon: IconDefinition;
   color: string;
   /**
    * для использования внутри style
    */
   cssColor: string;
   /**
    * для коротких урлов
    */
   smallPrefix: string;
};

export const ypViewConfig: Record<YpViewPart, ViewData> = {
   stage: {
      fontAwesomeIcon: faServer,
      color: 'black',
      cssColor: 'var(--yc-color-text-primary)',
      smallPrefix: 'st',
   },
   deployUnit: {
      fontAwesomeIcon: faRocket,
      color: '#ff9a00',
      cssColor: '#ff9a00',
      smallPrefix: 'du',
   },
   box: {
      fontAwesomeIcon: faBoxOpen,
      color: '#2fa2ce',
      cssColor: 'var(--color-skyblue-dark, #2fa2ce)',
      smallPrefix: 'box',
   },
   workload: {
      fontAwesomeIcon: faHeartRate,
      color: '#45d496',
      cssColor: 'var(--color-bluegreen, #45d496)',
      smallPrefix: 'wl',
   },
   layer: {
      fontAwesomeIcon: faLayerGroup,
      color: '#45d496',
      cssColor: 'var(--color-bluegreen, #45d496)',
      smallPrefix: 'lr',
   },
   staticResource: {
      fontAwesomeIcon: faFile,
      color: '#45d496',
      cssColor: 'var(--color-bluegreen, #45d496)',
      smallPrefix: 'st',
   },
   volume: {
      fontAwesomeIcon: faCompactDisc,
      color: '#2fa2ce',
      cssColor: 'var(--color-skyblue-dark, #2fa2ce)',
      smallPrefix: 'vol',
   },
};
