import { urlBuilder } from './urlBuilder';

describe('models|urlBuilder', () => {
   it('should build url from route and params', () => {
      expect(urlBuilder.build('/project/:id', { id: 'xxx' })).toBe('/project/xxx');

      expect(urlBuilder.build('/project/:id/configuration', { id: 'xxx' })).toBe('/project/xxx/configuration');
   });

   it('should skip unknown params', () => {
      expect(urlBuilder.build('/project/:projectId', { id: 'xxx' })).toBe('/project/:projectId');

      expect(urlBuilder.build('/project/:id/configuration', { projectId: 'xxx' })).toBe('/project/:id/configuration');
   });
});
