import { faCode, faKey } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import React from 'react';

import { EnvironmentVariableType } from '../../../models';

import classes from './EnvSubFormIcon.module.css';

interface Props {
   showText?: boolean;
   type: EnvironmentVariableType;
}

const icons = {
   [EnvironmentVariableType.Literal]: faCode,
   [EnvironmentVariableType.Secret]: faKey,
};

const text = {
   [EnvironmentVariableType.Literal]: 'Literal',
   [EnvironmentVariableType.Secret]: 'Secret',
};

export function EnvSubFormIcon({ type, showText = false }: Props) {
   return (
      <>
         <FontAwesomeIcon icon={icons[type]} className={classes.icon} />
         {showText && text[type]}
      </>
   );
}
