import { Meta, Story } from '@storybook/react';
import React, { useState } from 'react';

import { EnvSubFormLiteralForm } from './EnvSubFormLiteralForm';

const Template: Story<{ multiple: boolean }> = ({ multiple }) => {
   const [value, setValue] = useState({
      multipleList: new Set<string>(),
      value: null as string | null,
      name: null as string | null,
   });

   console.log(value);

   return (
      <>
         <EnvSubFormLiteralForm value={value} onChange={setValue} isMultiple={multiple} />
      </>
   );
};

export const Single = Template.bind({});
Single.args = { multiple: false };

export const Multiple = Template.bind({});
Multiple.args = { multiple: true };

export default {
   title: 'modules/environment/EnvSubFormLiteralForm',
} as Meta;
