import { FormChangeListener, InputField2, IPureValueProps, SetField, TextField2 } from '@yandex-infracloud-ui/libs';
import { Formik } from 'formik';
import React from 'react';

import { LiteralVariable } from '../../../models';

import classes from './EnvSubFormLiteralForm.module.css';

export const literalInitialFormParams = {
   multipleList: new Set<string>(),
   value: null as string | null,
   name: null as string | null,
};

type LiteralFormParams = typeof literalInitialFormParams;

export function getLiteralFormParams(env: LiteralVariable): LiteralFormParams {
   return {
      name: env.name,
      value: env.value,
      multipleList: new Set(),
   };
}

interface Props extends IPureValueProps<LiteralFormParams> {
   isMultiple: boolean;
   readonly?: boolean;
}

export const EnvSubFormLiteralForm: React.FC<Props> = React.memo(
   ({ isMultiple, readonly = false, value, onChange }) => (
      <Formik initialValues={value} onSubmit={onChange}>
         {() => (
            <div className={classes.wrapper}>
               <FormChangeListener onChange={onChange} />

               <div className={classes.textAreaField}>
                  <SetField
                     name={'multipleList'}
                     label={
                        <>
                           Enter list of variables in form of <code>VARIABLE=value</code>
                        </>
                     }
                     hidden={!isMultiple}
                     controlProps={{ separator: /\n/ }}
                  />
               </div>

               <InputField2
                  name={'name'}
                  label={'Name'}
                  hidden={isMultiple}
                  readonly={readonly}
                  readonlyDots={readonly}
                  required={true}
               />

               <TextField2
                  controlProps={{ monospaceFont: true, readonlyPre: readonly }}
                  hidden={isMultiple}
                  label={!readonly ? 'Value' : null}
                  name={'value'}
                  readonly={readonly}
                  required={true}
               />
            </div>
         )}
      </Formik>
   ),
);

EnvSubFormLiteralForm.displayName = 'EnvSubFormLiteralForm';
