import { RemoveButton } from '@yandex-infracloud-ui/libs';
import React, { SyntheticEvent, useCallback } from 'react';

import CopyToClipboard from '../../../../../old-code/components/CopyToClipboard/CopyToClipboard';
import { handleStopPropagation } from '../../../../../utils';
import { SelectedSecretName } from '../../../../secrets';
import { EnvironmentVariable, EnvironmentVariableType } from '../../../models';

import { EnvSubFormIcon } from '../__icon/EnvSubFormIcon';
import classes from './EnvSubFormRow.module.css';

interface Props {
   readonly: boolean;
   value: EnvironmentVariable;

   onRemove(name: string): void;

   onSelect(name: string): void;
}

export const EnvSubFormRow: React.FC<Props> = ({ value, onRemove, onSelect, readonly }) => {
   const handleRemove = useCallback(() => onRemove(value.name), [onRemove, value.name]);

   const handleRowClick = useCallback(
      (e: SyntheticEvent) => {
         const target = e.target as EventTarget & Element;
         if (target.tagName === 'A' || target.tagName === 'BUTTON') {
            return;
         }

         onSelect(value.name);
      },
      [onSelect, value.name],
   );

   return (
      <tr onClick={handleRowClick}>
         <td className={classes.keyColumn}>
            <EnvSubFormIcon type={value.type} /> {value.name}
         </td>

         <td className={classes.valueColumn}>
            {value.type === EnvironmentVariableType.Literal ? value.value : null}

            {value.type === EnvironmentVariableType.Secret && value.value ? (
               <SelectedSecretName selectedSecret={value.value} />
            ) : null}
         </td>

         {/* eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions */}
         <td className={classes.copyValue} onClick={handleStopPropagation}>
            {value.type === EnvironmentVariableType.Literal ? <CopyToClipboard value={value.value} /> : null}
         </td>

         {/* eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions */}
         <td className={classes.remove} onClick={handleStopPropagation}>
            {!readonly ? <RemoveButton onClick={handleRemove} /> : null}
         </td>
      </tr>
   );
};
