import { FieldLayout2, FormChangeListener, InputField2, IPureValueProps, isEmpty } from '@yandex-infracloud-ui/libs';
import { Formik } from 'formik';
import React, { useCallback } from 'react';

import { LinkToSecret } from '../../../../../models/ui/secrets';

import { SecretSubForm } from '../../../../secrets';
import { SecretVariable } from '../../../models';

import classes from './EnvSubFormSecretForm.module.css';

export const secretInitialFormParams = {
   name: '',
   secret: null as LinkToSecret | null,
};

type SecretFormParams = typeof secretInitialFormParams;

export function getSecretFormParams(env: SecretVariable): SecretFormParams {
   return {
      name: env.name,
      secret: env.value,
   };
}

interface Props extends IPureValueProps<SecretFormParams> {
   duId: string;
   readonly?: boolean;
   stageId: string;
}

export const EnvSubFormSecretForm: React.FC<Props> = React.memo(
   ({ stageId, duId, value, onChange, readonly = false }) => {
      const handleChange = useCallback(
         (v: SecretFormParams) => {
            if (isEmpty(v.name) && v.secret) {
               v.name = v.secret.key;
            }

            onChange(v);
         },
         [onChange],
      );

      return (
         <Formik initialValues={value} onSubmit={handleChange}>
            {() => (
               <div className={classes.wrapper}>
                  <FormChangeListener onChange={handleChange} />

                  <InputField2
                     name={'name'}
                     label={'Name'}
                     placeholder={'Enter variable...'}
                     readonly={readonly}
                     readonlyDots={readonly}
                     required={true}
                  />

                  <FieldLayout2
                     name={'secret'}
                     label={'Secret'}
                     readonly={readonly}
                     readonlyDots={readonly}
                     required={true}
                  >
                     <SecretSubForm
                        duId={duId}
                        name={'secret'}
                        stageId={stageId}
                        layout={'vertical'}
                        disabled={false}
                        readonly={readonly}
                     />
                  </FieldLayout2>
               </div>
            )}
         </Formik>
      );
   },
);

EnvSubFormSecretForm.displayName = 'EnvSubFormSecretForm';
