import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import React from 'react';

import { apiServicesContextDecorator } from '../../../../../stories';

import { stageWithSecretsDecorator } from '../../../../secrets/storybook/stageWithSecretsDecorator';
import { SECRETS_DEMO_STAGE_ID } from '../../../../secrets/storybook/StageWithSecretStory';
import { EnvironmentVariable, EnvironmentVariableType } from '../../../models';

import { EnvSubFormVariableModal } from './EnvSubFormVariableModal';

const duId = 'du_manual_secrets';

interface Props {
   variable?: EnvironmentVariable;
   isNew: boolean;
}

const Story: React.FC<Props> = ({ isNew, variable }) => (
   <EnvSubFormVariableModal
      cancel={action('cancel')}
      duId={duId}
      isNew={isNew}
      nameList={[]}
      ok={action('ok')}
      readonly={boolean('readonly', false)}
      stageId={SECRETS_DEMO_STAGE_ID}
      variable={variable}
   />
);

export const AddVariable = () => <Story isNew={true} />;

export const EditLiteral = () => (
   <Story
      isNew={false}
      variable={{
         type: EnvironmentVariableType.Literal,
         name: 'test',
         value: 'test value',
      }}
   />
);

export const EditSecret = () => (
   <Story
      isNew={false}
      variable={{
         type: EnvironmentVariableType.Secret,
         name: 'testSecret',
         value: {
            alias: 'INFRACLOUDUI',
            key: 'SSH_KEY',
         },
      }}
   />
);

export const EditDeniedSecret = () => (
   <Story
      isNew={false}
      variable={{
         type: EnvironmentVariableType.Secret,
         name: 'testSecret',
         value: {
            alias: 'secret:alias',
            key: 'SSH_KEY',
         },
      }}
   />
);

export default {
   decorators: [apiServicesContextDecorator, stageWithSecretsDecorator(duId)],
   title: 'modules/environment/EnvSubFormVariableModal',
} as Meta;
