import { getLinkToSecret } from '../../../models/ui/secrets';
import { TEnvVar } from '../../../proto-typings';

import { EnvironmentVariable } from '../models/EnvironmentVariable';
import { EnvironmentVariableType } from '../models/EnvironmentVariableType';

export function convertEnvironment(env: TEnvVar[] | undefined): EnvironmentVariable[] {
   if (!env) {
      return [];
   }

   return env
      .filter(v => v.value?.literal_env || v.value?.secret_env)
      .map(v => {
         const literal = v.value!.literal_env;
         if (literal) {
            return {
               name: v.name ?? '',
               type: EnvironmentVariableType.Literal,
               value: literal.value ?? '',
            };
         }

         return {
            name: v.name ?? '',
            type: EnvironmentVariableType.Secret,
            value: getLinkToSecret(v.value!.secret_env!),
         } as EnvironmentVariable;
      });
}
