import { SecretUsage, SecretUsageType } from '../../../models/ui/secrets';
import { EnvironmentVariable, EnvironmentVariableType } from '../models';

export function getSecretUsagesFromEnvironment(
   pathPrefix: string,
   environment: EnvironmentVariable[],
   alias: string | null,
): SecretUsage[] {
   const result: SecretUsage[] = [];

   for (const variable of environment) {
      // Переменные с непустым секретом (с нужным алиасом)
      if (
         variable.type === EnvironmentVariableType.Secret &&
         variable.value &&
         (alias === null || variable.value.alias === alias)
      ) {
         result.push({
            key: variable.value.key,
            path: `${pathPrefix}[${variable.name}]`,
            type: SecretUsageType.Environment,
         });
      }
   }

   return result;
}
