import { LiteralEnvSelector, TEnvVar } from '../../../proto-typings';
import { EnvironmentVariable, EnvironmentVariableType } from '../models';
import { patchEnvironment } from './patchEnvironment';

describe('models/environment/patchEnvironment', () => {
   it('Should keep literal_env as is for empty value (with value field)', () => {
      const specEnv: TEnvVar[] = [
         {
            name: 'test',
            value: {
               literal_env: ({
                  value: '',
               } as Partial<LiteralEnvSelector>) as any,
            } as any,
         },
      ];

      const environment: EnvironmentVariable[] = [
         {
            name: 'test',
            type: EnvironmentVariableType.Literal,
            value: '',
         },
      ];

      // @ts-ignore
      patchEnvironment(specEnv, environment);

      expect(specEnv[0]).toEqual({
         name: 'test',
         value: {
            literal_env: {
               value: '',
            },
         },
      });
   });

   it('Should keep literal_env as is for empty value (without value field)', () => {
      const specEnv: TEnvVar[] = [
         {
            name: 'test',
            value: {
               literal_env: {} as any,
            } as any,
         },
      ];

      const environment: EnvironmentVariable[] = [
         {
            name: 'test',
            type: EnvironmentVariableType.Literal,
            value: '',
         },
      ];
      // @ts-ignore
      patchEnvironment(specEnv, environment);

      expect(specEnv[0]).toEqual({
         name: 'test',
         value: {
            literal_env: {},
         },
      });
   });

   it('Should add literal_env for empty literal variables (for new variables)', () => {
      const specEnv: TEnvVar[] = [];

      const environment: EnvironmentVariable[] = [
         {
            name: 'test',
            type: EnvironmentVariableType.Literal,
            value: '',
         },
      ];
      // @ts-ignore
      patchEnvironment(specEnv, environment);

      expect(specEnv[0]).toEqual({
         name: 'test',
         value: {
            literal_env: {},
         },
      });
   });
});
