import { getSetDifference } from '@yandex-infracloud-ui/libs';

import { patchSecret } from '../../../models/ui/secrets';
import { StageParentNodeIds } from '../../../models/ui/stage/StageParentNodeIds';
import { patch, patchObject, patchString } from '../../../models/ui/utils';
import { TEnvVar } from '../../../proto-typings';
import { SecretResolver } from '../../secrets';

import { EnvironmentVariable, EnvironmentVariableType } from '../models';

export function patchEnvironment(
   specEnv: TEnvVar[],
   environment: EnvironmentVariable[],
   secretResolver: SecretResolver,
   parentNodes: StageParentNodeIds,
) {
   for (const env of environment) {
      const index = specEnv.some(v => (v.name ?? '') === env.name)
         ? specEnv.findIndex(v => (v.name ?? '') === env.name)
         : specEnv.length; // new in the end

      const variableSpec = specEnv[index] ?? { name: env.name };

      patchObject(variableSpec, 'value', value => {
         // noinspection JSDeprecatedSymbols
         patch(value, 'literal_env', null as any, literalEnvNullable => {
            if (env.type !== EnvironmentVariableType.Literal) {
               return undefined;
            }

            // Это хак для того, чтобы обойти проверку на дефолтное значение.
            // Нам важно сохранить объект, даже пустой.
            // А пустой объект не добавляется, т.к. является дефолтным значением.
            const literalEnv = literalEnvNullable ?? {};

            patchString(literalEnv, 'value', () => env.value?.trim());

            return literalEnv;
         });

         patchObject(value, 'secret_env', secretEnv => {
            if (env.type !== EnvironmentVariableType.Secret) {
               return undefined;
            }
            patchSecret(secretEnv, env.value, secretResolver, parentNodes.stageId, parentNodes.duId!);

            return secretEnv;
         });

         return value;
      });

      specEnv[index] = variableSpec;
   }

   // handle removed
   const { removed } = getSetDifference(new Set(specEnv.map(v => v.name ?? '')), new Set(environment.map(v => v.name)));

   removed.forEach(name => {
      const i = specEnv.findIndex(v => v.name === name);
      specEnv.splice(i, 1);
   });

   return specEnv;
}
