import { environmentValidationSchema } from './environmentValidationSchema';
import { EnvironmentVariable } from './EnvironmentVariable';
import { EnvironmentVariableType } from './EnvironmentVariableType';

describe('models/environment/environmentValidationSchema', () => {
   it('should add variable name as prefix for errors ', () => {
      expect(() =>
         environmentValidationSchema.validateSync([
            {
               name: 'test_x',
               type: EnvironmentVariableType.Secret,
               value: { key: '', alias: '' },
            } as EnvironmentVariable,
         ]),
      ).toThrowError('test_x: Secret alias must be at least 1 characters');
   });
});
