import { BaseApi, HttpMethod } from '@yandex-infracloud-ui/libs';
import { Observable } from 'rxjs';
import { InfoEntry, StatEntry } from './model';

export class InfraDoctorApi extends BaseApi {
   constructor(apiPrefix: string) {
      super(`${apiPrefix}/api/v1/`);
      console.log(this);
   }

   getCSRF() {
      return '';
   }

   handleError() {
      return undefined;
   }

   info(params: InfoEntry['query']): Observable<InfoEntry['response']> {
      return this.request({
         method: HttpMethod.GET,
         path: 'info',
         credentials: 'same-origin',
         params,
         onlyJson: true,
      });
   }

   stat(params: StatEntry['query']): Observable<StatEntry['response']> {
      return this.request({
         method: HttpMethod.GET,
         path: 'stat',
         credentials: 'same-origin',
         params,
         onlyJson: true,
      });
   }
}
