import type { LabelProps } from '@yandex-cloud/uikit';
import type { IssueClass, SummaryLevel } from '../model';

export const labelThemeByLevel: Record<SummaryLevel, LabelProps['theme']> = {
   crit: 'danger',
   warn: 'warning',
   info: 'info',
   ok: 'success',
   unknown: 'unknown',
};

export const issueClassTitles: Record<IssueClass, string> = {
   security: 'Security',
   old_infra_resources: 'Old resources',
   access_issues: 'Access',
   best_practice: 'Best practice',
   other: 'Other',
};

export function restoreOrder<T extends string>(customOrder: T[], defaultOrder: string[], values: T[]): T[] {
   const valueSet = new Set(values);

   const availableCustomOrder = customOrder.filter(id => valueSet.has(id));
   const customOrderSet = new Set(availableCustomOrder);

   const availableDefaultOrder = defaultOrder.filter(
      id => !customOrderSet.has(id as any) && valueSet.has(id as any),
   ) as T[];
   const defaultOrderSet = new Set(availableCustomOrder);

   const tailOrder = values.filter(id => !customOrderSet.has(id) && !defaultOrderSet.has(id)).sort();

   return [...availableCustomOrder, ...availableDefaultOrder, ...tailOrder];
}
