import { Issue, IssueLevel, ObjectType } from './objects';

export interface StatRequestQuery {
   id: string;
   object_type: ObjectType;
   uuid?: string;
}

export type AggregatedStatistics = Record<string, AggregatedResponse>;

/**
 * AggregatedStatisticsResponse returns data for aggregated issues
 */
export interface StatResponse {
   /**
    * statistics, map stage_id в статистику
    */
   statistics: AggregatedStatistics | null;
   relative: Partial<Record<ObjectType, AggregatedStatistics>> | null;
}

export interface AggregatedResponse {
   count_by_level: Partial<Record<IssueLevel, number>>;
}

export interface InfoRequestQuery {
   id: string;
   object_type: ObjectType;
   uuid?: string;
}

/**
 * Response returns data for stage issues
 */
export interface InfoResponse {
   /**
    * Issue list
    */
   issues: Issue[];
   /**
    * YP object id
    */
   object_id: string;
   /**
    * Object revisionq
    */
   revision: number;
}

export interface InfoEntry {
   query: InfoRequestQuery;
   response: InfoResponse;
}

export interface StatEntry {
   query: StatRequestQuery;
   response: StatResponse;
}
