// описание типов запросов и ответов

export type IssueActionCode = 'update-runtime-version' | 'update-sidecars' | 'help' | '';
export interface Action {
   code: IssueActionCode;
   message: string;
}

export type YpObjectType = 'stage' | 'project';
export type ObjectType = (string & {}) | `yp.${YpObjectType}`;

export type IssueCode = (number & {}) | 1;

export interface Issue {
   action: Action;
   class: IssueClass;
   description: string;
   issue_code: IssueCode;
   level: IssueLevel;
   locator: string;
}

export type IssueClass = 'security' | 'old_infra_resources' | 'access_issues' | 'best_practice' | 'other';
export const issueClasses: IssueClass[] = [
   'security',
   'old_infra_resources',
   'access_issues',
   'best_practice',
   'other',
];

export type IssueLevel = 'crit' | 'warn' | 'info';
export const issueLevels: IssueLevel[] = ['crit', 'warn', 'info'];
