import { Issue, IssueLevel, issueLevels } from './objects';

export type SummaryLevel = IssueLevel | 'ok' | 'unknown';
export const summaryLevels: SummaryLevel[] = [...issueLevels, 'ok', 'unknown'];

export type IssueSummary = {
   summaryLevel: IssueLevel | 'ok' | 'unknown';
   totalCount: number;
   countByLevel: Record<IssueLevel, number>;
};

export const getDefaultIssueSummary: () => IssueSummary = () => ({
   summaryLevel: 'unknown',
   totalCount: 0,
   countByLevel: Object.fromEntries(issueLevels.map(level => [level, 0])) as Record<IssueLevel, number>,
});

export function getIssueSummaryFromList({ issues }: { issues: Issue[] }): { summary: IssueSummary } {
   const summary = getDefaultIssueSummary();

   // подсчёт проблем
   for (const issue of issues) {
      const { level } = issue;
      summary.countByLevel[level] += 1;
      summary.totalCount += 1;
   }

   // суммарный статус
   summary.summaryLevel = 'ok';
   for (const level of issueLevels) {
      if (summary.countByLevel[level] > 0) {
         summary.summaryLevel = level;
         break;
      }
   }

   return { summary };
}
