import { formatMeasureValue, getPositionalUnitMeasures, MeasureFormatOptions } from '../../../utils';

export enum ByteMeasureUnit {
   B = 'B',
   KB = 'KB',
   MB = 'MB',
   GB = 'GB',
   TB = 'TB',
   PB = 'PB',
   EB = 'EB',
}

export const byteUnitList = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB'] as const;
export const byteBaseMultiplier = 1024;

const byteUnitMeasures = getPositionalUnitMeasures(byteUnitList, byteBaseMultiplier);

export type FormatBytesOptions = MeasureFormatOptions<keyof typeof byteUnitMeasures>;

export function formatBytes(value: number, options?: FormatBytesOptions) {
   return formatMeasureValue(value, byteUnitMeasures, options);
}
