import { formatMeasureValue, getPositionalUnitMeasures, MeasureFormatOptions } from '../../../utils';

export enum BytePerSecondMeasureUnit {
   'B/s' = 'B/s',
   'KB/s' = 'KB/s',
   'MB/s' = 'MB/s',
   'GB/s' = 'GB/s',
   'TB/s' = 'TB/s',
   'PB/s' = 'PB/s',
   'EB/s' = 'EB/s',
}

export const bytePerSecondUnitList = ['B/s', 'KB/s', 'MB/s', 'GB/s', 'TB/s', 'PB/s', 'EB/s'] as const;
export const bytePerSecondBaseMultiplier = 1024;

const bytePerSecondUnitMeasures = getPositionalUnitMeasures(bytePerSecondUnitList, bytePerSecondBaseMultiplier);

export type FormatBytesPerSecondOptions = MeasureFormatOptions<keyof typeof bytePerSecondUnitMeasures>;

export function formatBytesPerSecond(value: number, options?: FormatBytesPerSecondOptions) {
   return formatMeasureValue(value, bytePerSecondUnitMeasures, options);
}
