import { formatMeasureValue, MeasureFormatOptions } from '../../../utils';

export enum CoresMeasureUnit {
   ms = 'ms',
   cores = 'cores',
}

export const coresMeasures = {
   [CoresMeasureUnit.ms]: 1,
   [CoresMeasureUnit.cores]: 1000,
};

export type CoresFormatOptions = MeasureFormatOptions<keyof typeof coresMeasures>;

export function formatCores(value: number, options?: MeasureFormatOptions<keyof typeof coresMeasures>) {
   return formatMeasureValue(value, coresMeasures, options);
}
