import { action } from '@storybook/addon-actions';
import { Meta, Story } from '@storybook/react';
import React from 'react';

import { apiServicesContextDecorator, reduxDecorator } from '../../../../stories';
import { stageWithSecretsDecorator } from '../../storybook/stageWithSecretsDecorator';

import { AddSecretModal } from './AddSecretModal';

const Template: Story<{}> = () => <AddSecretModal cancel={action('cancel')} ok={action('ok')} />;

export const Regular = Template.bind({});

Regular.storyName = 'AddSecretModal'; // Remove if it isn't single story
Regular.args = {};
Regular.decorators = [stageWithSecretsDecorator('du_manual_secrets')];

export default {
   decorators: [apiServicesContextDecorator, reduxDecorator],
   title: 'modules/secrets/AddSecretModal',
} as Meta;
