import { action } from '@storybook/addon-actions';
import { Meta } from '@storybook/react';
import React from 'react';

import { apiServicesContextDecorator, reduxDecorator } from '../../../../stories';
import { stageWithSecretsDecorator } from '../../storybook/stageWithSecretsDecorator';

import { AddVersionModal } from './AddVersionModal';

// noinspection SpellCheckingInspection
export const Regular = () => (
   <AddVersionModal
      secretUuid={'sec-01dec420c9rpdgdc9p3astjs0x'}
      secretName={'INFRACLOUDUI'}
      cancel={action('cancel')}
      ok={action('ok')}
   />
);
Regular.storyName = 'AddVersionModal';
Regular.decorators = [stageWithSecretsDecorator('du_manual_secrets')];

export default {
   decorators: [apiServicesContextDecorator, reduxDecorator],
   title: 'modules/secrets/AddVersionModal',
} as Meta;
