import { action } from '@storybook/addon-actions';
import { Meta, Story } from '@storybook/react';
import React from 'react';
import { stageWithSecretsDecorator } from '../../storybook/stageWithSecretsDecorator';

import { EditAliasModal } from './EditAliasModal';

const Template: Story<{ newAlias: string | undefined }> = ({ newAlias }) => (
   <EditAliasModal
      ok={action('ok')}
      cancel={action('cancel')}
      duVersion={{
         alias: 'old_alias',
         versionUuid: 'xxxx',
         newAlias,
         usages: [],
      }}
      suggestedAliases={['new_alias']}
   />
);

export const FirstEdit = Template.bind({});
FirstEdit.args = { newAlias: undefined };
FirstEdit.decorators = [stageWithSecretsDecorator('du_manual_secrets')];

export const AlreadyEdited = Template.bind({});
AlreadyEdited.args = { newAlias: 'newAlias' };
AlreadyEdited.decorators = [stageWithSecretsDecorator('du_manual_secrets')];

export default {
   title: 'modules/secrets/EditAliasModal',
} as Meta;
