import { ExtendedFieldConfig, FieldLayout2, useExtendedField } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { NewSecretSelectFieldInput } from './__input/NewSecretSelectFieldInput';

interface NewSecretSelectFieldControlProps {
   alreadyAddedSecrets: string[];
}

export const NewSecretSelectField = React.memo(
   (props: ExtendedFieldConfig<any, string, NewSecretSelectFieldControlProps>) => {
      const { field, onChange, onBlur, readonly, disabled, showError } = useExtendedField(props);

      return (
         <FieldLayout2 {...props}>
            {readonly ? (
               <div>{field.value}</div>
            ) : (
               <NewSecretSelectFieldInput
                  dataTest={props['data-test']}
                  disabled={disabled}
                  hasError={showError}
                  name={field.name}
                  onBlur={onBlur}
                  onChange={onChange}
                  readonly={readonly}
                  value={field.value}
               />
            )}
         </FieldLayout2>
      );
   },
);

NewSecretSelectField.displayName = 'NewSecretSelectField';
