import React, { useState } from 'react';

import { Meta, Story } from '@storybook/react';

import { DevJson } from '../../../../../components/lib';
import { apiServicesContextDecorator } from '../../../../../stories';
import { stageWithSecretsDecorator } from '../../../storybook/stageWithSecretsDecorator';

import { NewSecretSelectFieldInput } from './NewSecretSelectFieldInput';

const Template: Story<{ duId: string; value: string }> = ({ duId, value: initialValue }) => {
   const [value, setValue] = useState(initialValue);

   return (
      <>
         <NewSecretSelectFieldInput name={'test'} onChange={setValue} value={value} />
         <DevJson open={true}>{{ value }}</DevJson>
      </>
   );
};

export const Autogenerated = Template.bind({});
Autogenerated.args = {};
Autogenerated.decorators = [stageWithSecretsDecorator('du_autogen_secrets')];

export const Manual = Template.bind({});
Manual.args = {};
Manual.decorators = [stageWithSecretsDecorator('du_manual_secrets')];

export const HasValue = Template.bind({});
HasValue.args = { value: 'sec-01dec420c9rpdgdc9p3astjs0x' };
HasValue.decorators = [stageWithSecretsDecorator('du_manual_secrets')];

export default {
   decorators: [apiServicesContextDecorator],
   title: 'modules/secrets/NewSecretSelectFieldInput',
} as Meta;
