import { Meta, Story } from '@storybook/react';
import React from 'react';

import { apiServicesContextDecorator, modalsSupportDecorator } from '../../../../stories';
import { stageWithSecretsDecorator } from '../../storybook/stageWithSecretsDecorator';

import { SecretList } from './SecretList';

interface StoryArgs {
   disabled: boolean;
   readonly: boolean;
}

const Template: Story<StoryArgs> = ({ disabled, readonly }) => <SecretList disabled={disabled} readonly={readonly} />;

export const Autogenerated = Template.bind({});
Autogenerated.decorators = [stageWithSecretsDecorator('du_autogen_secrets')];
Autogenerated.args = { disabled: false, readonly: false };

export const Manual = Template.bind({});
Manual.decorators = [stageWithSecretsDecorator('du_manual_secrets')];
Manual.args = { disabled: false, readonly: false };

export const Empty = Template.bind({});
Empty.decorators = [stageWithSecretsDecorator('du_empty_secrets')];
Empty.args = { disabled: false, readonly: false };

export default {
   decorators: [apiServicesContextDecorator, modalsSupportDecorator],
   title: 'modules/secrets/SecretList',
} as Meta;
