import { DropdownMenu } from '@yandex-cloud/uikit';
import React from 'react';

import { DeployUnitSecret, DeployUnitSecretVersion } from '../../../models';
import { SecretListLayoutContext } from '../models';

interface Props {
   secret: DeployUnitSecret;
   version: DeployUnitSecretVersion;
   context: SecretListLayoutContext;
}

export const SecretListLayoutActionsCell = React.memo(({ secret, version, context }: Props) => (
   <DropdownMenu
      items={[
         {
            text: 'Migrate to new storage',
            action: () => context.handleMigrate(version.alias),
            extraProps: { 'data-e2e': 'SecretVersion:MigrateButton' },
            disabled: context.disabled,
            hidden: version.migrated || !version.legacy,
         },
         {
            text: 'Undo migration',
            action: () => context.handleUndoMigration(version.alias),
            extraProps: { 'data-e2e': 'SecretVersion:UndoMigrationButton' },
            disabled: context.disabled,
            hidden: !version.migrated,
         },
         {
            text: 'Edit alias',
            action: () => context.handleAliasEdit(secret.secretUuid, version),
            extraProps: { 'data-e2e': 'SecretVersion:EditAliasButton' },
            disabled: context.disabled,
            hidden: version.removed,
         },
      ]}
   />
));

SecretListLayoutActionsCell.displayName = 'SecretListLayoutActionsCell';
