import { faExclamationTriangle } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { WarningPlate } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { SimplePopup } from '../../../../../components/lib';

import { isSecretAliasGenerated, isSecretAliasGeneratedCorrectly } from '../../../helpers';
import { DeployUnitSecret, DeployUnitSecretVersion } from '../../../models';

import classes from './SecretListLayoutAliasCell.module.css';

interface Props {
   secret: DeployUnitSecret;
   version: DeployUnitSecretVersion;
}

export const SecretListLayoutAliasCell: React.FC<Props> = React.memo(({ secret, version }) => (
   <>
      {isSecretAliasGenerated(version.alias) ? (
         <div className={classes.alias}>
            <span title={version.alias}>Autogenerated</span>{' '}
            {isSecretAliasGeneratedCorrectly(version.alias, secret!.secretUuid, version.versionUuid) ? null : (
               <SimplePopup
                  popupClassName={classes.popup}
                  switcher={<FontAwesomeIcon icon={faExclamationTriangle} className={classes.warning} />}
                  directions={[
                     'bottom-center',
                     'bottom-right',
                     'bottom-left',
                     'left-bottom',
                     'left-center',
                     'left-top',
                     'top-center',
                     'top-right',
                     'top-left',
                  ]}
               >
                  <WarningPlate>The secret alias does not match with the Secret/Version ID.</WarningPlate>
               </SimplePopup>
            )}
         </div>
      ) : (
         <code>{version.alias}</code>
      )}

      {version.newAlias && (
         <div>
            New alias: <code>{version.newAlias}</code>
         </div>
      )}
   </>
));

SecretListLayoutAliasCell.displayName = 'SecretListLayoutAliasCell';
