import { Dictionary } from '@reduxjs/toolkit';
import { action } from '@storybook/addon-actions';
import { Meta, Story } from '@storybook/react';
import React from 'react';

import { SecretUsageType } from '../../../../../models/ui/secrets';
import { DeployUnitSecret, Secret, SecretVersion } from '../../../models';
import { stageWithSecretsDecorator } from '../../../storybook/stageWithSecretsDecorator';

import { SecretListLayout } from './SecretListLayout';

// noinspection SpellCheckingInspection
const duSecrets: DeployUnitSecret[] = [
   {
      secretUuid: 'sec-01dec420c9rpdgdc9p3astjs0x',
      versions: [
         // new storage
         {
            versionUuid: 'ver-01erj3s88hsyahp063efjsd12m',
            usages: [
               {
                  key: 'YT_TOKEN',
                  path: 'box[xx].workload[wl].environment[YT_TOKEN]',
                  type: SecretUsageType.Environment,
               },
            ],
            alias: 'ver-01erj3s88hsyahp063efjsd12m',
         },
         // old storage (legacy)
         {
            versionUuid: 'ver-01erj3s88hsyahp063efjsd12m',
            usages: [
               {
                  key: 'YT_TOKEN',
                  path: 'box[xx].workload[wl].environment[YT_TOKEN]',
                  type: SecretUsageType.Environment,
               },
            ],
            alias: 'ver-01erj3s88hsyahp063efjsd12m',
            token: 'xxxxxx',
            legacy: true,
         },
      ],
   },
];

// noinspection SpellCheckingInspection
const secrets: Dictionary<Secret | undefined> = {
   'sec-01dec420c9rpdgdc9p3astjs0x': { denied: false, uuid: 'sec-01dec420c9rpdgdc9p3astjs0x' },
};

// noinspection SpellCheckingInspection
const versions: Dictionary<SecretVersion[]> = {
   'sec-01dec420c9rpdgdc9p3astjs0x': [
      {
         version: 'ver-01erj3s88hsyahp063efjsd12m',
         keys: ['YT_TOKEN', 'SSH_KEY'],
         createdBy: 'khoden',
         createdAt: Date.now(),
      },
   ],
};

const Template: Story<{ disabled: boolean; readonly: boolean }> = ({ disabled, readonly }) => (
   <SecretListLayout
      disabled={disabled}
      duSecrets={duSecrets}
      onAddSecret={action('onAddSecret')}
      onAddSecretVersion={action('onAddSecretVersion')}
      onAliasEdit={action('onAliasEdit')}
      onMigrate={action('onMigrate')}
      onMigrateAll={action('onMigrateAll')}
      onRemoveUnused={action('onRemoveUnused')}
      onUndoMigration={action('onUndoMigration')}
      readonly={readonly}
      secrets={secrets}
      versions={versions}
   />
);

export const Regular = Template.bind({});
Regular.args = {
   disabled: false,
   readonly: false,
};

export default {
   decorators: [stageWithSecretsDecorator('du_manual_secrets')],
   title: 'modules/secrets/SecretListLayout',
} as Meta;
