import { faEraser, faPlus } from '@fortawesome/pro-regular-svg-icons';
import { FormButton } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { pluralNumber } from '../../../../../utils';
import { DeployUnitSecret } from '../../../models';
import { SecretName } from '../../SecretName/SecretName';
import classes from '../__layout/SecretListLayout.module.css';
import { SecretListUsages } from '../__usages/SecretListUsages';
import { SecretListLayoutContext } from '../models';

interface Props {
   context: SecretListLayoutContext;
   secret: DeployUnitSecret;
}

export const SecretListLayoutSecretCell: React.FC<Props> = React.memo(({ secret, context }) => {
   const { readonly, disabled, handleAddVersion, handleRemoveUnused, secrets } = context;

   const versionCount = secret.versions.length;
   const usages = secret.versions.map(v => ({ version: v.versionUuid, usages: v.usages }));
   const usageCount = secret.versions.reduce((acc, v) => acc + v.usages.length, 0);
   const hasUnusedVersions = secret.versions.some(v => !v.removed && v.usages.length === 0);
   const richSecret = secrets[secret.secretUuid];

   const showAddButton = !richSecret?.denied;

   return (
      <>
         <SecretName secretUuid={secret.secretUuid} className={classes.name} />

         <div className={classes.info}>
            {pluralNumber(versionCount, 'version', 'versions')}, <SecretListUsages count={usageCount} obj={usages} />
         </div>

         {!readonly && (
            <div className={classes.buttons}>
               {showAddButton && (
                  <FormButton
                     disabled={disabled}
                     icon={faPlus}
                     onClick={() => handleAddVersion(secret.secretUuid)}
                     skipLeftSpace={true}
                  >
                     Add version
                  </FormButton>
               )}

               {hasUnusedVersions && (
                  <FormButton
                     disabled={disabled}
                     icon={faEraser}
                     onClick={() => handleRemoveUnused(secret.secretUuid)}
                     skipLeftSpace={!showAddButton}
                  >
                     Clean unused
                  </FormButton>
               )}
            </div>
         )}
      </>
   );
});

SecretListLayoutSecretCell.displayName = 'SecretListLayoutSecretCell';
