import React from 'react';

import { faExclamationTriangle } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Json, WarningPlate } from '@yandex-infracloud-ui/libs';

import { SimplePopup } from '../../../../../components/lib';
import { pluralNumber } from '../../../../../utils';

import classes from './SecretListUsages.module.css';

interface Props {
   count: number;
   obj: any;
}

export const SecretListUsages: React.FC<Props> = React.memo(({ count, obj }) => (
   <SimplePopup
      className={classes.switcher}
      popupClassName={classes.popup}
      switcher={
         <>
            {pluralNumber(count, 'usage', 'usages')}
            {count === 0 && (
               <>
                  {' '}
                  <FontAwesomeIcon icon={faExclamationTriangle} className={classes.warning} />
               </>
            )}
         </>
      }
   >
      {count > 0 ? (
         <Json obj={obj} hidePre={true} />
      ) : (
         <WarningPlate>
            This secret can still be used in parts of the spec that are not yet supported in UI.
            <br />
            For example, in static or dynamic resources. Be careful when deleting it.
         </WarningPlate>
      )}
   </SimplePopup>
));

SecretListUsages.displayName = 'SecretListUsages';
