import { ExternalLink, formatDate, Json, splitBy } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { Badge, BadgeType, SimplePopup } from '../../../../../components/lib';

import { EXTERNAL_LINKS } from '../../../../../models';
import { isMultisecret } from '../../../../../models/ui/secrets';
import { pluralNumber } from '../../../../../utils';
import { DeployUnitSecret, DeployUnitSecretVersion } from '../../../models';
import { SecretListUsages } from '../__usages/SecretListUsages';
import { SecretListLayoutContext } from '../models';

import classes from '../__layout/SecretListLayout.module.css';

interface Props {
   context: SecretListLayoutContext;
   secret: DeployUnitSecret;
   version: DeployUnitSecretVersion;
}

export const SecretListLayoutVersionCell: React.FC<Props> = React.memo(({ version, secret: parent, context }) => {
   const { versions } = context;
   const richVersion = versions[parent!.secretUuid]?.find(v => v.version === version.versionUuid);

   const [multiSecretKeys, keys] = splitBy(richVersion?.keys ?? [], isMultisecret);

   return (
      <>
         <ExternalLink
            href={EXTERNAL_LINKS.secretVersion(parent!.secretUuid, version.versionUuid)}
            className={classes.versionLink}
            data-e2e={'SecretVersion:Link'}
         >
            {richVersion?.createdAt ? formatDate(new Date(richVersion.createdAt)) : version.versionUuid}
         </ExternalLink>

         {richVersion && (
            <div className={classes.info}>
               <SimplePopup className={classes.switcher} switcher={pluralNumber(keys.length, 'key', 'keys')}>
                  <Json obj={keys} />
               </SimplePopup>
               {multiSecretKeys.length > 0 && (
                  <>
                     ,
                     <SimplePopup
                        className={classes.switcher}
                        switcher={pluralNumber(multiSecretKeys.length, 'multisecret', 'multisecrets')}
                     >
                        <Json obj={multiSecretKeys} />
                     </SimplePopup>
                  </>
               )}
               , <SecretListUsages count={version.usages.length} obj={version.usages} />
            </div>
         )}

         {version.removed && <div className={classes.removed}>Will remove on save</div>}

         {/*
         {version.legacy && (
            <Badge type={BadgeType.Warning} title={'Old secret storage'} data-e2e={'SecretVersion:LegacyBadge'}>
               Legacy
            </Badge>
         )}
         */}

         {!version.legacy && (
            <Badge type={BadgeType.Success} title={'New secret storage'} data-e2e={'SecretVersion:NewBadge'}>
               New storage
            </Badge>
         )}
      </>
   );
});

SecretListLayoutVersionCell.displayName = 'SecretListLayoutVersionCell';
