import { Dictionary } from '@reduxjs/toolkit';

import { DeployUnitSecretVersion, Secret, SecretVersion } from '../../models';

export interface SecretListLayoutContext {
   disabled: boolean;
   readonly: boolean;
   secrets: Dictionary<Secret | undefined>;
   versions: Dictionary<SecretVersion[]>;

   handleAddVersion(secretUuid: string): void;

   handleAliasEdit(secretUuid: string, duVersion: DeployUnitSecretVersion): void;

   handleRemoveUnused(secretUuid: string): void;

   handleMigrate(alias: string): void;

   handleUndoMigration(alias: string): void;
}
