// noinspection SpellCheckingInspection

import { Meta, Story } from '@storybook/react';
import React from 'react';
import { generateMultisecretKey } from '../../../../models/ui/secrets';

import { apiServicesContextDecorator } from '../../../../stories';

import { SecretName } from './SecretName';

export const Regular1 = () => <SecretName secretUuid={'sec-01dpnnv45fmwbfhfqgqy344zz7'} />;

export const WithKey = () => <SecretName secretUuid={'sec-01dpnnv45fmwbfhfqgqy344zz7'} secretKey={'SSH_KEY'} />;

export const Multisecret = () => (
   <SecretName secretUuid={'sec-01dpnnv45fmwbfhfqgqy344zz7'} secretKey={generateMultisecretKey()} />
);

export const Regular2 = () => <SecretName secretUuid={'sec-01dec420c9rpdgdc9p3astjs0x'} />;

export const Denied = () => <SecretName secretUuid={'sec-01d6bkr38deswha5zrszemkm50'} />;

export const AllVariants = () => (
   <>
      <SecretName secretUuid={'sec-01dpnnv45fmwbfhfqgqy344zz7'} />
      <SecretName secretUuid={'sec-01d6bkr38deswha5zrszemkm50'} />
      <SecretName secretUuid={'sec-01dpnnv45fmwbfhfqgqy344zz7'} secretKey={'SSH_KEY'} />
      <SecretName secretUuid={'sec-01dpnnv45fmwbfhfqgqy344zz7'} secretKey={generateMultisecretKey()} />
      <SecretName secretUuid={'sec-01d6bkr38deswha5zrszemkm50'} secretKey={'SSH_KEY'} />
   </>
);

const LimitedWidthTemplate: Story<{ width: number }> = ({ width }) => (
   <div
      style={{
         width,
      }}
   >
      <SecretName
         secretUuid={'sec-01dpnnv45fmwbfhfqgqy344zz7'}
         secretKey={'SSH_KEYSSH_KEYSSH_KEYSSH_KEYSSH_KEYSSH_KEY'}
      />{' '}
   </div>
);

export const LimitedWidth = LimitedWidthTemplate.bind({});
LimitedWidth.args = { width: 300 };

export default {
   decorators: [apiServicesContextDecorator],
   title: 'modules/secrets/SecretName',
   argTypes: {
      width: {
         control: { type: 'range', min: 100, max: 1200, step: 50 },
      },
   },
} as Meta;
