import { faLock, faLockOpen } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Spin } from '@yandex-cloud/uikit';
import { classNames } from '@yandex-infracloud-ui/libs';
import React, { useCallback, useEffect } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { loadSecret, selectSecret } from '../../slice';
import { RootStateWithSecrets } from '../../slice/state';
import { SecretNameLink } from './__link/SecretNameLink';

import classes from './SecretName.module.css';

interface Props {
   secretUuid: string;
   className?: string;
   secretKey?: string;
}

export const SecretName: React.FC<Props> = React.memo(({ secretUuid, secretKey, className }) => {
   const secretSelector = useCallback((s: RootStateWithSecrets) => selectSecret(s, secretUuid), [secretUuid]);
   const secret = useSelector(secretSelector);
   const dispatch = useDispatch();

   useEffect(() => {
      if (!secret || (!secret.denied && !secret.name)) {
         dispatch(loadSecret(secretUuid));
      }
   }, [dispatch, secret, secretUuid]);

   return (
      <div className={classNames(classes.wrapper, className)}>
         {!secret ? (
            <Spin className={classes.spin} />
         ) : secret.denied ? (
            <FontAwesomeIcon icon={faLock} fixedWidth={true} className={classes.icon} />
         ) : (
            <FontAwesomeIcon icon={faLockOpen} fixedWidth={true} className={classes.icon} />
         )}
         <SecretNameLink className={classes.link} uuid={secretUuid} name={secret?.name} secretKey={secretKey} />
      </div>
   );
});

SecretName.displayName = 'SecretName';
