import { ExternalLink } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { EXTERNAL_LINKS } from '../../../../../models';
import { DEFAULT_MULTISECRET_FORMAT, extractFormat, isMultisecret } from '../../../../../models/ui/secrets';
import { handleStopPropagation } from '../../../../../utils';

interface Props {
   className?: string;
   uuid: string;
   name?: string;
   secretKey?: string;
}

export function SecretNameLink({ className, secretKey, name, uuid }: Props) {
   return (
      <>
         {name ?? uuid}
         <ExternalLink
            className={className}
            href={EXTERNAL_LINKS.secretLink(uuid)}
            title={'Open in Yandex.Vault'}
            onClick={handleStopPropagation}
         >
            {''}
         </ExternalLink>

         {secretKey ? (
            <>
               / <span title={secretKey}>{formatSecretKey(secretKey)}</span>
            </>
         ) : null}
      </>
   );
}

function formatSecretKey(key: string): string {
   if (isMultisecret(key)) {
      return `All keys in ${extractFormat(key) ?? DEFAULT_MULTISECRET_FORMAT} format`;
   }

   return key;
}
