import { action } from '@storybook/addon-actions';
import { Meta, Story } from '@storybook/react';
import { Button } from '@yandex-cloud/uikit';
import { FieldLayout2 } from '@yandex-infracloud-ui/libs';
import { Form, Formik } from 'formik';
import React from 'react';

import { DevForm } from '../../../../components/lib';
import { StageConverter } from '../../../../models/ui';
import { LinkToSecret } from '../../../../models/ui/secrets';
import { apiServicesContextDecorator, modalsSupportDecorator, testSecretsStage } from '../../../../stories';
import { stageWithSecretsDecorator } from '../../storybook/stageWithSecretsDecorator';

import { SecretSubForm } from './SecretSubForm';

const stage = StageConverter.fromApi(testSecretsStage as any);
const initialValues = {
   secret: {
      alias: 'INFRACLOUDUI',
      key: 'FONTAWESOME_NPM_AUTH_TOKEN',
      isMulti: false,
   } as LinkToSecret | null,
   emptySecret: null as LinkToSecret | null,
};

interface StoryArgs {
   duId: string;
   layout: 'vertical' | 'horizontal';
   readonly: boolean;
   disabled: boolean;
   allowMultisecret: boolean;
}

const Template: Story<StoryArgs> = ({ duId, layout, readonly, disabled, allowMultisecret }) => (
   <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
      {() => (
         <Form>
            <FieldLayout2 name={'secret'} label={'Secret'}>
               <SecretSubForm
                  name={'secret'}
                  stageId={stage.id}
                  duId={duId}
                  disabled={disabled}
                  readonly={readonly}
                  layout={layout}
                  allowMultisecret={allowMultisecret}
               />
            </FieldLayout2>

            <FieldLayout2 name={'emptySecret'} label={'Empty secret'}>
               <SecretSubForm
                  name={'emptySecret'}
                  stageId={stage.id}
                  duId={duId}
                  disabled={disabled}
                  readonly={readonly}
                  layout={layout}
                  allowMultisecret={allowMultisecret}
               />
            </FieldLayout2>

            <Button type={'submit'}>Submit</Button>

            <DevForm />
         </Form>
      )}
   </Formik>
);

export const Regular = Template.bind({});
Regular.decorators = [stageWithSecretsDecorator('du_manual_secrets')];
Regular.args = {
   duId: 'du_manual_secrets',
   layout: 'vertical',
   disabled: false,
   readonly: false,
   allowMultisecret: false,
};

export const Multisecret = Template.bind({});
Multisecret.decorators = [stageWithSecretsDecorator('du_manual_secrets')];
Multisecret.args = {
   duId: 'du_manual_secrets',
   layout: 'vertical',
   disabled: false,
   readonly: false,
   allowMultisecret: true,
};

export default {
   decorators: [apiServicesContextDecorator, modalsSupportDecorator],
   title: 'modules/secrets/SecretSubForm',
   argTypes: {
      layout: {
         control: { type: 'inline-radio' },
         options: ['horizontal', 'vertical'],
      },
      duId: {
         control: { type: 'radio' },
         options: ['du_autogen_secrets', 'du_manual_secrets', 'du_empty_secrets'],
      },
   },
} as Meta;
