import { Meta, Story } from '@storybook/react';
import React, { useCallback, useState } from 'react';

import { DevJson } from '../../../../../components/lib';

import { SecretSubFormKeySelect } from './SecretSubFormKeySelect';

const Template: Story<{ allowMultisecret: boolean }> = ({ allowMultisecret }) => {
   const [value, setValue] = useState('');

   const handleChange = useCallback((v: string) => setValue(v), []);

   return (
      <>
         <SecretSubFormKeySelect
            availableKeys={['key1', 'key2']}
            name={'test'}
            onChange={handleChange}
            value={value}
            allowMultisecret={allowMultisecret}
         />
         <DevJson open={true}>{value}</DevJson>
      </>
   );
};

export const Regular = Template.bind({});

Regular.storyName = 'KeySelect';
Regular.args = { allowMultisecret: false };

export default {
   title: 'modules/secrets/SecretSubForm/KeySelect',
} as Meta;
