import { YCSelectItem, YCSelectItemsGroup } from '@yandex-data-ui/common';
import { BaseInputProps } from '@yandex-infracloud-ui/libs';
import React, { useMemo } from 'react';

import { SingleSelect, valuesToSelectItems } from '../../../../../components/forms';
import { generateMultisecretKey } from '../../../../../models/ui/secrets';
import { EMultiSecretFileContentFormat } from '../../../../../proto-typings';

interface Props extends BaseInputProps<string | undefined> {
   allowMultisecret: boolean;
   className?: string;
   availableKeys: string[];
   dataTest?: string;
}

export const SecretSubFormKeySelect: React.FC<Props> = React.memo(
   ({ availableKeys, placeholder, allowMultisecret, ...props }) => {
      const items: YCSelectItem[] | YCSelectItemsGroup[] = useMemo(() => {
         const keys = valuesToSelectItems(availableKeys);

         if (!allowMultisecret) {
            return keys;
         }

         const formats: YCSelectItem[] = Object.values(EMultiSecretFileContentFormat).map(format => ({
            value: generateMultisecretKey(format),
            title: `All keys in "${format}" format`,
         }));

         return [
            { groupTitle: 'All keys', items: formats },
            { groupTitle: 'One key', items: keys },
         ];
      }, [allowMultisecret, availableKeys]);

      return <SingleSelect items={items} placeholder={placeholder} {...props} />;
   },
);

SecretSubFormKeySelect.displayName = 'SecretSubFormKeySelect';
