import React, { useState } from 'react';

import { action } from '@storybook/addon-actions';
import { Meta, Story } from '@storybook/react';

import { DevJson } from '../../../../../components/lib';
import { apiServicesContextDecorator } from '../../../../../stories';

import { useDuSecretsWithVersions } from '../../../hooks';
import { stageWithSecretsDecorator } from '../../../storybook/stageWithSecretsDecorator';
import { SECRETS_DEMO_STAGE_ID } from '../../../storybook/StageWithSecretStory';

import { SecretSubFormVersionSelect } from './SecretSubFormVersionSelect';

const Template: Story<{ duId: string; value: string }> = ({ duId, value: initialValue }) => {
   const { duSecrets, versions, secrets } = useDuSecretsWithVersions(SECRETS_DEMO_STAGE_ID, duId);
   const [value, setValue] = useState(initialValue);

   return (
      <>
         <SecretSubFormVersionSelect
            duSecrets={duSecrets}
            name={'test'}
            onBlur={action('onBlur')}
            onChange={setValue}
            secrets={secrets}
            value={value}
            versions={versions}
         />
         <DevJson open={true}>{{ value }}</DevJson>
      </>
   );
};

export const Autogenerated = Template.bind({});
Autogenerated.args = { duId: 'du_autogen_secrets' };
Autogenerated.decorators = [stageWithSecretsDecorator('du_autogen_secrets', true)];

export const Manual = Template.bind({});
Manual.args = { duId: 'du_manual_secrets' };
Manual.decorators = [stageWithSecretsDecorator('du_manual_secrets', true)];

export const HasValue = Template.bind({});
HasValue.args = { duId: 'du_manual_secrets', value: 'INFRACLOUDUI' };
HasValue.decorators = [stageWithSecretsDecorator('du_manual_secrets', true)];

export default {
   decorators: [apiServicesContextDecorator],
   title: 'modules/secrets/SecretSubForm/VersionSelect',
} as Meta;
