import { Meta, Story } from '@storybook/react';
import React from 'react';

import { LinkToSecret } from '../../../../models/ui/secrets';
import { configContextDecorator } from '../../../../stories';
import { stageWithSecretsDecorator } from '../../storybook/stageWithSecretsDecorator';

import { SelectedSecretName } from './SelectedSecretName';

const Template: Story<LinkToSecret> = selectedSecret => <SelectedSecretName selectedSecret={selectedSecret} />;

export const Existed = Template.bind({});
Existed.args = {
   alias: 'INFRACLOUDUI',
   key: 'FONTAWESOME_NPM_AUTH_TOKEN',
};

export const NotExistedGenerated = Template.bind({});
NotExistedGenerated.args = {
   alias: 'sec-01d6bkr38deswha5zrszemkm50:ver-01dvzmdb0pxdg9z1t60few7s71',
   key: 'SOME_KEY',
};

export const NotExistedManual = Template.bind({});
NotExistedManual.args = {
   alias: 'UNKNOWN_ALIAS',
   key: 'SOME_KEY',
};

export default {
   decorators: [configContextDecorator, stageWithSecretsDecorator('du_manual_secrets')],
   title: 'modules/secrets/SelectedSecretName',
} as Meta;
