import React, { useCallback } from 'react';
import { useSelector } from 'react-redux';

import { LinkToSecret } from '../../../../models/ui/secrets';
import { useSecretsContext } from '../../hooks/useSecretsContext';
import { RootStateWithSecrets, selectDuSecretByAlias } from '../../slice';
import { SecretName } from '../SecretName/SecretName';

import classes from './SelectedSecretName.module.css';

interface Props {
   selectedSecret: LinkToSecret;
   className?: string;
}

export const SelectedSecretName: React.FC<Props> = React.memo(({ className, selectedSecret }) => {
   const { stageId, duId } = useSecretsContext();

   const { alias } = selectedSecret;
   const selector = useCallback((s: RootStateWithSecrets) => selectDuSecretByAlias(s, stageId, duId, alias), [
      alias,
      duId,
      stageId,
   ]);
   const duSecret = useSelector(selector);

   if (!duSecret) {
      return (
         <>
            {alias} <span className={classes.alias}>(alias)</span>
         </>
      );
   }

   return <SecretName secretUuid={duSecret.secretUuid} className={className} secretKey={selectedSecret.key} />;
});

SelectedSecretName.displayName = 'SelectedSecretName';
