import React from 'react';

import { noop } from '../../utils';
import { SecretsContext } from './models';

export function addSecretContext<P>(WrappedComponent: React.FC<P>, stageId: string, duId: string): React.FC<P> {
   function WithSecretContext(p: P) {
      return (
         <SecretsContext.Provider value={{ stageId, duId, reloadUsages: noop }}>
            <WrappedComponent {...p} />
         </SecretsContext.Provider>
      );
   }

   WithSecretContext.displayName = `addSecretContext(${getDisplayName(WrappedComponent)})`;

   return WithSecretContext;
}

function getDisplayName<P>(WrappedComponent: React.FC<P>): string {
   return WrappedComponent.displayName || WrappedComponent.name || 'Component';
}
