import { useContext } from 'react';
import { useRafDelay } from '../../../utils';

import { SecretsContext } from '../models';

export function useSecretsContext() {
   const { duId, stageId, reloadUsages } = useContext(SecretsContext);
   if (!stageId || !duId) {
      throw new Error('You must define SecretsContext value in a parent component');
   }

   const delayedReloadUsages = useRafDelay(reloadUsages);

   return { duId, stageId, reloadUsages: delayedReloadUsages };
}
