import { SecretUsage } from '../../../models/ui/secrets';

export interface DeployUnitSecretVersion {
   versionUuid: string;

   /**
    * Признак того, что эта версия (алиас) хранится в старом хранилище (secrets).
    */
   legacy?: boolean;

   /**
    * Уникальная строка для связки с секретом в podSpec.models
    *
    * Генерируется.
    * Формат <secret_id>:<secret_version>, но может и отличаться в старых стейджах.
    *
    * @example sec-01dr6kwd7ggxg428em72adpamt:ver-01drbvspj7j2x06tej21x9jtga
    */
   alias: string;

   /**
    * На случай, если алиас был переименован, тут будет храниться новое значение.
    * До сохранения оно нигде не используется, кроме как для валидации уникальности алиасов.
    * Учитывается только в DeployUnitPatcher при сохранении изменений.
    */
   newAlias?: string;

   /**
    * Только для старых секретов!
    * Токен зависит от:
    * secretUuid, signature(stage_id, du_id)
    */
   token?: string;

   usages: SecretUsage[];

   /**
    * Признак, что версия была вручную удалена (напрямую или через операции в SecretList)
    */
   removed?: boolean;

   /**
    * Признак того, что эта версия (алиас) уже был мигрирован в новый формат
    */
   migrated?: boolean;
}
