import { isEmpty } from '@yandex-infracloud-ui/libs';

import { DeployUnitSecret, TokenStore } from '../models';
import { RootStateWithSecrets, selectDeployUnitSecrets } from '../slice';

export class SecretResolver {
   constructor(private state: RootStateWithSecrets, private tokenStore: TokenStore) {}

   public resolveToken(stageId: string, duId: string, secretUuid: string, versionUuid: string): string {
      // Сначала ищем в только что выписанных токенах
      const fromTokenStore = this.tokenStore.find(r => r.duId === duId && r.secretUuid === secretUuid)?.token;
      if (fromTokenStore) {
         return fromTokenStore;
      }

      // Пытаемся взять текущий токен
      const duSecrets = this.getDuSecrets(stageId, duId);
      const duSecret = duSecrets?.find(ds => ds.secretUuid === secretUuid);

      // Токен из переданной версии в приоритете (родной)
      const duVersion = duSecret?.versions.find(v => v.versionUuid === versionUuid && !isEmpty(v.token));
      if (duVersion?.token) {
         return duVersion.token;
      }

      // В указанной версии токен на нашелся, берем у соседней (токен не зависит от версии)
      return duSecret?.versions.find(v => !isEmpty(v.token))?.token ?? '';
   }

   public getDuSecrets(stageId: string, duId: string): DeployUnitSecret[] | undefined {
      return selectDeployUnitSecrets(this.state, stageId, duId);
   }

   public getActualAlias(stageId: string, duId: string, alias: string): string {
      const duSecrets = this.getDuSecrets(stageId, duId) ?? [];

      for (const duSecret of duSecrets) {
         for (const duVersion of duSecret.versions) {
            if (!duVersion.removed && (duVersion.alias === alias || duVersion.newAlias === alias)) {
               return duVersion.newAlias ?? duVersion.alias;
            }
         }
      }

      return alias;
   }
}
