import { createAsyncThunk } from '@reduxjs/toolkit';
import { firstValueFrom } from 'rxjs';

import { Secret } from '../../models';
import { getSecretsApi } from '../../services';

import { namespace } from '../state';

export const loadSecret = createAsyncThunk<Secret, string>(`${namespace}/loadSecret`, secretId =>
   firstValueFrom(getSecretsApi().getById(secretId)),
);
